function OnePageCtrl($scope, $rootScope, StructureJson, PageJson, $location, NotesStorage, $injector){
    $injector.invoke(PageCtrl, this, {
        $scope: $scope,
        $rootScope: $rootScope,
        StructureJson: StructureJson,
        PageJson: PageJson,
        $location: $location,
        NotesStorage: NotesStorage
    });


    /**
     * Event odpowiadający za załadowanie danych do strony
     */
    $scope.$on('Page:change', function(e, changeData){
        if(changeData.singleView)
        {
            if(changeData.direction == 1)
            {
                $scope.p = $scope.$parent.getNextPage(changeData.currentPage);
            }
            else
            {
                $scope.p = $scope.$parent.getPreviousPage(changeData.currentPage);
            }
        }
        else
        {
            if(changeData.direction == 1)
            {
                $scope.p = $scope.$parent.getNextPage($scope.$parent.getNextPage(changeData.currentPage))
            }
            else
            {
                $scope.p = $scope.$parent.getPreviousPage($scope.$parent.getPreviousPage(changeData.currentPage));
            }
        }

        $scope.pageData = PageJson.loadPage($scope.p);
        $scope.$apply();
    });

    /**
     * Zdarzenie odpowiadające za przeskok do jakiejś strony
     */
    $scope.$on('Page:jump', function(e, page){
        $scope.p = page;
        $scope.pageData = PageJson.loadPage($scope.p)
        $scope.$apply();
    });
}

//OnePageCtrl.prototype = Object.create(PageCtrl.prototype);
OnePageCtrl.$inject = ['$scope', '$rootScope', 'StructureJson', 'PageJson', '$location', 'NotesStorage', '$injector'];
